import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Spellcheck {
    public static void main(String[] args) throws IOException {
        String RESET = "\u001B[0m";
        String RED = "\u001B[31m";

        try (BufferedReader dictionary = new BufferedReader(new FileReader(args[1], Charset.forName("UTF-8")))) {

            Spelling spelling = new Spelling(dictionary);

            String text = Files.readString(Paths.get(args[0]), Charset.forName("UTF-8"));

            for (Object w : spelling.checkText(text)) {
                Spelling.Word word = (Spelling.Word)w;
                if (!word.isCorrect())
                    System.out.print(RED + word + " " + RESET);
                else
                    System.out.print(word + " ");
            }
        }
    }
}
