import java.io.*;

public class Spelling {
    private LinkedList list;

    public class Word {
        private String word;
        private boolean isCorrect;

        public Word(String word, boolean isCorrect) {
            this.word = word;
            this.isCorrect = isCorrect;
        }

        public boolean isCorrect() {
            return isCorrect;
        }

        public String toString() {
            return word;
        }
    }

    public Spelling(Reader reader) throws IOException {
        list = new LinkedList();

        BufferedReader br = new BufferedReader(reader);

        String word;

        while ((word = br.readLine()) != null) {
            if (!word.startsWith("%")) {
                list.add(word.toLowerCase());
            }
        }

        reader.close();
    }

    public boolean checkWord(String word) {
        return list.contains(word.toLowerCase());
    }

    public LinkedList checkText(String text) {
        String[] tokens = text.split("[ .,:;\r\n]+");

        LinkedList result = new LinkedList();

        for (String token : tokens) {
            result.add(new Word(token, list.contains(token.toLowerCase())));
        }

        return result;
    }
}
