import java.util.Iterator;

public class LinkedList<T> implements Iterable<T> {

    private class Node {
        public T item;
        public Node next;

        public Node(T item, Node next) {
            this.item = item;
            this.next = next;
        }
    }

    private Node first, last;
    private int size;

    public int size() {
        return size;
    }

    public void add(T item) {
        Node newNode = new Node(item, null);

        if (first == null) { // erster einzufügender Knoten
            first = newNode;
            last = newNode;
        } else {
            last.next = newNode;
            last = newNode;
        }
        size++;
    }

    public void addAll(T[] items) {
        for (T item : items) {
            add(item);
        }
    }

    public boolean remove(T item) {
        Node node = find(item);

        if (node == null)
            return false;

        Node previousNode = findPrevious(item);

        // aus Mitte oder Ende entfernen
        if (previousNode != null) { 
            previousNode.next = node.next;

            if (node == last) {
                last = previousNode;
            }
        } else { // remove first node
            first = node.next;

            if (first == null) { // list becomes empty
                last = null;
            }
        }

        size--;

        return true;
    }

    public boolean contains(T item) {
        Node node = find(item);

        return (node != null);
    }

    public void clear() {
        first = null;
        last = null;
        size = 0;
    }

    public T get(int index) {

        Node node = findByIndex(index);
        return node.item;
    }

    public void set(int index, T item) {
        Node node = findByIndex(index);
        node.item = item;
    }

    private Node find(T item) {
        Node node = first;

        while (node != null) {
            if (node.item.equals(item)) {
                return node;
            }

            node = node.next;
        }

        return null;
    }

    private Node findPrevious(T item) {
        Node previousNode = null;
        Node node = first;

        while (node != null) {
            if (node.item.equals(item))
                return previousNode;

            previousNode = node;
            node = node.next;
        }

        return null;
    }

    private Node findByIndex(int index) {

        if (index >= size)
            throw new IndexOutOfBoundsException();

        Node node = first;
        int i = 0;

        while (node != null) {

            if (i == index) 
                return node;

            node = node.next;
            i++;
        }
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        Node node = first;

        while (node != null) {
            s += node.item.toString() + " -> ";
            node = node.next;
        }

        s += "Count: " + size;

        return s;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedListIterator();
    }

    private class LinkedListIterator implements Iterator<T> {
        private Node currentNode = first;

        public boolean hasNext() {
            return (currentNode != null);
        }

        public T next() {
            if (!hasNext()) {
                throw new IndexOutOfBoundsException();
            }

            T item = currentNode.item;
            currentNode = currentNode.next;

            return item;
        }
    }
}