import java.util.Iterator;

public class ArrayList<T> implements Iterable<T> {
    private T[] items;
    private int size;

    @SuppressWarnings("unchecked")
    public ArrayList(int length) {
        items = (T[])new Object[length];
    }

    public ArrayList() {
        this(4);
    }

    public int size() {
        return size;
    }

    public void add(T item) {

        grow();

        items[size] = item;

        size++;
    }

    public void addAll(T[] items) {

        for (T item : items)
            add(item);
    }

    public int indexOf(T item) {
        for (int i = 0; i < size; i++) {
            if (items[i].equals(item)) {
                return i;
            }
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0 || index >= size)
            throw new IndexOutOfBoundsException();

        // ein Eintrag nach links verschieben
        System.arraycopy(items, index + 1, items, index, size - (index + 1));

        size--;
        items[size] = null; // Garbage Collector
    }

    public boolean remove(T item) {
        for (int i = 0; i < size; i++) {
            if (items[i].equals(item)) {
                removeAt(i);
                return true;
            }
        }
        return false;
    }

    @SuppressWarnings("unchecked")
    public void clear() {
        items = (T[])new Object[4];
        size = 0;
    }


    public T get(int index) {
        if (index >= size)
            throw new IndexOutOfBoundsException();

        return (T) items[index];
    }

    public void set(int index, T item) {
        if (index >= size)
            throw new IndexOutOfBoundsException();

        items[index] = item;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayListIterator();
    }

    @Override
    public String toString() {
        String s = "";
        for (int i = 0; i < size; i++)
            s += items[i].toString() + " -> ";

        s += "Count: " + size;
        return s;
    }

    @SuppressWarnings("unchecked")
    private void grow() {

        // Überprüfen, ob noch Platz
        if (items.length >= size + 1)
            return;

        // Array-Kapazität verdoppeln
        int newLength = items.length * 2;

        var newArray = new Object[newLength];
        System.arraycopy(items, 0, newArray, 0, size);
        items = (T[])newArray;
    }

    private class ArrayListIterator implements Iterator<T> {
        private int currentIndex;

        @Override
        public boolean hasNext() {
            return currentIndex < size;
        }

        @Override
        public T next() {
            return (T) items[currentIndex++];
        }
    }
}
