public class StringExtension {
    
    public static boolean isNumeric(String s) {
        return s.matches("-?\\d+(\\.\\d+)?");
    }
    
    public static double evaluateExpression(String s) {

        Stack<String> ops = new Stack<String>();
        Stack<Double> vals = new Stack<Double>();
        
        String[] tokens = s.split(" ");
        
        for (String t : tokens) {
            if (isNumeric(t))
                vals.push(Double.parseDouble(t));
            else
                ops.push(t);
            
            if (vals.size() == 2) {
                double v2 = vals.pop();
                double v1 = vals.pop();
                
                switch (ops.pop()) {
                case "+":
                    vals.push(v1 + v2);
                    break;
                case "-":
                    vals.push(v1 - v2);
                    break;
                case "*":
                    vals.push(v1 * v2);
                    break;
                case "/":
                    vals.push(v1 / v2);
                    break;
                }
            }
        }
        
        return vals.pop();
    }
}
