public class QueueCircularBuffer<T> implements ICollection {

    private Object[] items;
    private int first = 0, last = 0;
    private int size;

    public QueueCircularBuffer(int length) {
        items = new Object[length];
    }

    public QueueCircularBuffer() {
        this(10);
    }

    public int size() {
        return size;
    }

    public void enqueue(T item) {

        if (size == items.length)
            throw new OutOfMemoryError("No more space");

        items[last] = item;

        last++;
        size++;

        last = last % items.length; // Umlaufprüfung
    }

    @SuppressWarnings("unchecked")
    public T peek() {

        if (size() == 0)
            throw new IllegalStateException("No items");

        return (T) items[first];
    }

    @SuppressWarnings("unchecked")
    public T dequeue() {

        if (size() == 0)
            throw new IllegalStateException("No items");

        T item = (T) items[first];

        items[first] = null;

        first++;
        size--;

        first = first % items.length; // Umlaufprüfung

        return item;
    }

    @Override
    public void clear() {
        items = new Object[10];
        last = first = 0;
        size = 0;
    }

}
