public class Queue<T> implements ICollection {

    private Object[] items;
    private int size;

    public Queue(int length) {
        items = new Object[length];
    }

    public Queue() {
        this(10);
    }

    public int size() {
        return size;
    }

    public void enqueue(T item) {

        grow();

        items[size] = item;
        size++;
    }

    @SuppressWarnings("unchecked")
    public T peek() {
        if (size == 0)
            throw new RuntimeException("No items on stack.");

        return (T) items[0];
    }

    @SuppressWarnings("unchecked")
    public T dequeue() {

        if (size == 0)
            throw new RuntimeException("No items.");

        T item = (T) items[0];

        System.arraycopy(items, 1, items, 0, size - 1);

        items[size - 1] = null;
        size--;

        return item;
    }

    public void clear() {
        items = new Object[10];
        size = 0;
    }

    public String toString() {
        String s = "";

        for (int i = 0; i < size; i++) {
            s += items[i] + " -> ";
        }
        s += "Count: " + size;

        return s;
    }

    private void grow() {

        // Überprüfen, ob noch Platz
        if (items.length >= size + 1)
            return;

        // Array-Kapazität verdoppeln
        int newLength = items.length * 2;

        var newArray = new Object[newLength];
        System.arraycopy(items, 0, newArray, 0, size);
        items = newArray;
    }
}