
public class HashtableDoubleHashing<K, V> {

    @SuppressWarnings("unchecked")
    private static class Pair<K, V> {
        private K key;
        private V value;
        public boolean IsDeleted;

        public Pair(K key, V value, boolean isDeleted) {
            this.key = key;
            this.value = value;
            IsDeleted = isDeleted;
        }

        public void Value(Object value) {
            this.value = (V) value;
        }

        public V Value() {
            return this.value;
        }

        public K Key() {
            return this.key;
        }
    }

    private int size;

    public int size() {
        return size;
    }

    private Pair<?, ?>[] items;

    public HashtableDoubleHashing(int length) {

        length = calcPrimeLength(length * 2);
        if (length < 5)
            length = 5; // siehe Methode GetHashSteps
        items = new Pair[length];
    }

    public HashtableDoubleHashing() {
        this(10);
    }

    public void add(K key, V value) {
        if (containsKey(key))
            throw new IllegalArgumentException("Item already exists in collection");

        // Overflow, no more elements can be added
        if (size + 1 == items.length)
            throw new IllegalArgumentException("No more space in array");

        int hash = getHash(key);
        int steps = getHashSteps(key);

        while (items[hash] != null && !items[hash].IsDeleted) {
            hash += steps;
            hash %= items.length;
        }

        items[hash] = new Pair<K, V>(key, value, false);
        size++;
    }

    public boolean remove(K key) {
        int hash = getHash(key);
        int steps = getHashSteps(key);

        // bei add wird immer ein leeres Element beibebehalten, ansonsten
        // bei Füllgrad 100% Endlosschleife bei Suche nach nicht vorhandenem Element
        while (items[hash] != null) {
            if (items[hash].Key().equals(key) && !items[hash].IsDeleted) {
                // items[hash] nicht auf null setzen, da sonst beim Suchen dahinterliegende
                // nicht mehr gefunden werden
                // Kennzeichen, das Eintrag gelöscht. Kein Umkopieren im Array, da sich sonst
                // der Index verändert und der Hash nicht
                // mehr passt
                items[hash].IsDeleted = true;
                size--;
                return true;
            }
            hash += steps;
            hash %= items.length;
        }
        return false;
    }

    @SuppressWarnings("unchecked")
    public V get(K key) {
        int hash = getHash(key);
        int steps = getHashSteps(key);

        while (items[hash] != null) {
            if (items[hash].Key().equals(key) && !items[hash].IsDeleted) {
                return (V) items[hash].Value();
            }
            hash += steps;
            hash %= items.length;
        }
        throw new IllegalArgumentException("Key not found");
    }

    public void set(K key, V value) {
        if (!containsKey(key)) {
            add(key, value);
        } else {
            update(key, value);
        }
    }

    public void clear() {
        items = new Pair[items.length];
        size = 0;
    }

    public boolean contains(K key) {
        return containsKey(key);
    }

    public boolean containsKey(K key) {

        int hash = getHash(key);
        int steps = getHashSteps(key);

        while (items[hash] != null && !items[hash].IsDeleted) {
            if (items[hash].Key().equals(key)) {
                return true;
            }
            hash += steps;
            hash %= items.length;
        }
        return false;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < items.length; i++) {
            if (items[i] != null && !items[i].IsDeleted) {
                s += items[i].Key().toString() + "|" + items[i].Value().toString() + " -> ";
            }
        }
        return s + "Size: " + size;
    }

    private void update(K key, Object value) {
        int hash = getHash(key);
        int steps = getHashSteps(key);

        while (items[hash] != null && !items[hash].IsDeleted) {
            if (items[hash].Key().equals(key)) {
                items[hash].Value(value);
                break;
            }
            hash += steps;
            hash %= items.length;
        }
    }

    private static int calcPrimeLength(int length) {
        while (!isPrime(++length))
            ;
        return length;
    }

    private static boolean isPrime(int number) {
        for (int i = 2; i <= number / 2; i++) {
            if (number % i == 0) {
                return false;
            }
        }
        return true;
    }

    private int getHashSteps(K key) {
        return 5 - (key.hashCode() % 5);
    }

    private int getHash(K key) {
        return Math.abs(key.hashCode()) % items.length;
    }
}