public class BinaryTree<K extends Comparable<K>, V> {
    private class Node {
        public K Key;
        public V Value;
        public Node Left;
        public Node Right;

        public Node(K key, V value) {
            Key = key;
            Value = value;
        }
    }

    private Node root;
    private int size;

    public int size() {
        return size;
    }

    public K Min() {
        if (size == 0)
            throw new IllegalArgumentException("No items in tree.");

        Node node = root;

        K min = root.Key;

        while (node != null) {
            min = node.Key;
            node = node.Left;
        }
        return min;
    }

    public K Max() {
        if (size == 0)
            throw new IllegalArgumentException("No items in tree.");

        Node node = root;

        K max = root.Key;

        while (node != null) {
            max = node.Key;
            node = node.Right;
        }
        return max;
    }

    public TraverseModeEnum TraverseMode;

    public BinaryTree() {
        TraverseMode = TraverseModeEnum.PreOrder;
    }

    public void add(K key, V value) {

        if (root == null)
            root = new Node(key, value);
        else
            addTo(root, key, value);

        size++;
    }

    private void addTo(Node node, K key, V value) {
        if (key.compareTo(node.Key) < 0) {
            if (node.Left == null)
                node.Left = new Node(key, value);
            else
                addTo(node.Left, key, value);
        } else {
            if (node.Right == null)
                node.Right = new Node(key, value);
            else
                addTo(node.Right, key, value);
        }
    }

    public void addIterative(K key, V value) {
        if (root == null) {
            root = new Node(key, value);
            return;
        }

        Node node = root;
        while (node != null) {
            if (key.compareTo(node.Key) < 0) {
                if (node.Left == null) {
                    node.Left = new Node(key, value);
                    break;
                }
                node = node.Left;
            } else {
                if (node.Right == null) {
                    node.Right = new Node(key, value);
                    break;
                }
                node = node.Right;
            }

        }

        size++;
    }

    public boolean contains(K key) {
        Node node = root;

        while (node != null) {
            int c = key.compareTo(node.Key);

            if (c == 0)
                return true;

            if (c < 0)
                node = node.Left;
            else
                node = node.Right;
        }
        return false;
    }

    public V getValue(K key) {
        Node node = root;

        while (node != null) {
            int c = key.compareTo(node.Key);

            if (c == 0)
                return node.Value;

            if (c < 0)
                node = node.Left;
            else
                node = node.Right;
        }
        throw new IllegalArgumentException("Key doesn't exist.");
    }

    public void clear() {
        root = null;
        size = 0;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        int level = 0;

        traverse(root, level, s);

        return s.toString();
    }

    private void traverse(Node node, int level, StringBuilder s) {
        if (node == null)
            return;

        if (TraverseMode == TraverseModeEnum.PreOrder) {
            s.append(" ".repeat(level)).append(node.Key).append("\n");
            traverse(node.Left, level + 2, s);
            traverse(node.Right, level + 2, s);
        }
        if (TraverseMode == TraverseModeEnum.PostOrder) {
            traverse(node.Left, level + 2, s);
            traverse(node.Right, level + 2, s);
            s.append(" ".repeat(level)).append(node.Key).append("\n");
        }
        if (TraverseMode == TraverseModeEnum.InOrder) {
            traverse(node.Left, level + 2, s);
            s.append(" ".repeat(level)).append(node.Key).append("\n");
            traverse(node.Right, level + 2, s);
        }
        if (TraverseMode == TraverseModeEnum.ReverseInOrder) {
            traverse(node.Right, level + 2, s);
            s.append(" ".repeat(level)).append(node.Key).append("\n");
            traverse(node.Left, level + 2, s);
        }
    }
}