import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class App {
    public static void main(String[] args) throws Exception {

        if (args.length < 1)
            throw new IllegalArgumentException("Aufruf: CompanySearch <file.csv>");

        // CSV einlesen
        Companies companies = new Companies(new BufferedReader(
                new InputStreamReader(new FileInputStream(args[0]), StandardCharsets.UTF_8)));

        while (true) {
            System.out.print("Unternehmensbezeichnung eingeben: ");
            String name = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (name == null || name.isEmpty())
                break;

            Company company = companies.read(name);

            if (company == null)
                System.out.println("Unternehmen nicht gefunden!");
            else
                System.out.println(company + "\n");
        }
    }
}
