import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class Companies {
    private BinaryTree<String, Company> companies = new BinaryTree<>();

    public Companies(Reader r) throws IOException {
        BufferedReader reader = new BufferedReader(r);

        // Spaltenüberschriften auslesen
        String[] tokens = reader.readLine().split(";");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("More than 3 columns in company file");
        }

        String line;
        while ((line = reader.readLine()) != null) {
            tokens = line.split(";");
            companies.add(tokens[0], new Company(tokens[0], tokens[1], tokens[2]));
        }
        reader.close();
    }

    public Company read(String bezeichnung) {
        if (companies.contains(bezeichnung)) {
            return companies.getValue(bezeichnung);
        }
        return null;
    }
}