import java.io.BufferedReader;
import java.io.InputStreamReader;

public class App {
    public static void main(String[] args) throws Exception {

        if (args.length < 1) {
            throw new IllegalArgumentException("Aufruf: MusicDB <folder>");
        }

        Discs discs = new Discs(args[0]);

        // Musikdateien einlesen...
        discs.load();

        System.out.print("DiscId eingeben, z.B. 000cd512: ");

        String discId;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            while ((discId = reader.readLine()) != null && !discId.isEmpty()) {
                Disc title = discs.read(discId);

                if (title == null) {
                    System.out.println("Titel nicht gefunden!");
                } else {
                    System.out.println(title + "\n");
                }

                System.out.print("DiscId eingeben, z.B. 000cd512: ");
            }
        }
    }
}
