import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.*;
import java.util.List;

public class Discs {
    private RedBlackTree<String, Disc> discTitles;
    private String musicFolder;

    public Discs(String musicFolder) {
        this.musicFolder = musicFolder;
        this.discTitles = new RedBlackTree<>();
    }

    public void load() throws IOException {
        List<Path> files = Files.walk(Paths.get(musicFolder))
                .filter(Files::isRegularFile)
                .toList();

        for (Path file : files)
            readDiscFile(file.toString());
    }

    public Disc read(String discId) {
        if (discTitles.contains(discId))
            return discTitles.getValue(discId);

        return null;
    }

    private void readDiscFile(String filename) throws IOException {
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(new FileInputStream(filename), StandardCharsets.UTF_8))) {
            String line;
            String discTitle = null, genre = null, discId = null;
            int year = 0;

            while ((line = reader.readLine()) != null) {

                if (line.startsWith("#"))
                    continue;
                int index = line.indexOf('=');
                String key = line.substring(0, index);
                String value = line.substring(index + 1);

                switch (key) {
                    case "DISCID":
                        discId = value;
                        break;
                    case "DTITLE":
                        discTitle = value;
                        break;
                    case "DGENRE":
                        genre = value;
                        break;
                    case "DYEAR":
                        if (value != "")
                            year = Integer.parseInt(value);
                        break;
                }
            }

            if (discId != null)
                discTitles.add(discId, new Disc(discId, discTitle, year, genre));
        }
    }
}