import java.util.ArrayList;
import java.util.List;

public class Graph<T> {
    private List<Node<T>> nodes = new ArrayList<>();

    public List<Node<T>> getNodes() {
        return nodes;
    }

    public Node<T> addNode(T item) {

        Node<T> node = new Node<>();
        node.setItem(item);
        nodes.add(node);
        return node;
    }

    public void addEdge(Node<T> from, Node<T> to) {
        addEdge(from, to, null);
    }

    public void addEdge(Node<T> from, Node<T> to, Double weight) {
        from.getNeighbors().add(to);
        from.getWeights().add(weight);

        to.getNeighbors().add(from);
        to.getWeights().add(weight);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        for (var node : nodes) {
            sb.append(node).append(" -> ");

            var neighbors = new ArrayList<String>();
            for (int i = 0; i < node.getNeighbors().size(); i++) {
                Node<T> neighbor = node.getNeighbors().get(i);
                Double weight = node.getWeights().get(i);
                neighbors.add(String.format("%s (%s)", neighbor, weight == null ? "" : weight));
            }
            sb.append(String.join(", ", neighbors)).append("\n");
        }

        return sb.toString();
    }
}
