import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Graph<T> {
    private boolean directed;

    public Graph() {
        this(false);
    }

    public Graph(boolean directed) {
        this.directed = directed;
    }

    private List<Node<T>> nodes = new ArrayList<>();

    public List<Node<T>> getNodes() {
        return nodes;
    }

    public Node<T> addNode(T item) {

        Node<T> node = new Node<>();
        node.setItem(item);
        nodes.add(node);
        return node;
    }

    public void addEdge(Node<T> from, Node<T> to) {
        addEdge(from, to, null);
    }

    public void addEdge(Node<T> from, Node<T> to, Double weight) {
        from.getNeighbors().add(to);
        from.getWeights().add(weight);

        if (!directed) {
            to.getNeighbors().add(from);
            to.getWeights().add(weight);
        }
    }

    public boolean contains(T item) {
        for (var node : nodes) {
            if (node.getItem().equals(item) == true) {
                return true;
            }
        }
        return false;
    }

    public Node<T> get(T item) {

        for (var node : nodes) {
            if (node.getItem().equals(item) == true) {
                return node;
            }
        }
        throw new IndexOutOfBoundsException("Item not found");
    }

    public List<Node<T>> DFS() {
        var visited = new ArrayList<Node<T>>();

        nodes.forEach(n -> n.isVisited = null);

        var stack = new Stack<Node<T>>();

        nodes.get(0).isVisited = true;
        stack.push(nodes.get(0));
        visited.add(nodes.get(0));

        while (stack.size() > 0) {
            Node<T> neighbor = getNextUnvisitedNeighbor(stack.peek());

            if (neighbor == null) {
                stack.pop();
            } else {
                neighbor.isVisited = true;
                visited.add(neighbor);
                stack.push(neighbor);
            }
        }
        nodes.forEach(n -> n.isVisited = null);

        return visited;
    }

    public List<Node<T>> BFS() {

        var visited = new ArrayList<Node<T>>();

        nodes.forEach(n -> n.isVisited = null);

        var queue = new Queue<Node<T>>();

        nodes.get(0).isVisited = true;
        queue.enqueue(nodes.get(0));

        while (queue.size() > 0) {

            var node = queue.dequeue();
            visited.add(node);

            for (var neighbor : node.getNeighbors()) {

                if (neighbor.isVisited == null) {
                    neighbor.isVisited = true;
                    queue.enqueue(neighbor);
                }
            }
        }
        nodes.forEach(n -> n.isVisited = null);

        return visited;
    }

    private Node<T> getNextUnvisitedNeighbor(Node<T> node) {
        for (var neighbor : node.getNeighbors()) {

            if (neighbor.isVisited == null)
                return neighbor;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        for (var node : nodes) {
            sb.append(node).append(" -> ");

            var neighbors = new ArrayList<String>();
            for (int i = 0; i < node.getNeighbors().size(); i++) {
                Node<T> neighbor = node.getNeighbors().get(i);
                Double weight = node.getWeights().get(i);
                neighbors.add(String.format("%s (%s)", neighbor, weight == null ? "" : weight));
            }
            sb.append(String.join(", ", neighbors)).append("\n");
        }

        return sb.toString();
    }
}
