import java.util.Arrays;

public class SortedArrayList<T extends Comparable<T>> extends ArrayList<T> {

    public void bubbleSort() {
        boolean swapped = true;

        while (swapped) {
            swapped = false;

            for (int i = 0; i < size() - 1; i++) {
                if (get(i).compareTo(get(i + 1)) > 0) {
                    swap(i, i + 1);
                    swapped = true;
                }
            }
        }
    }

    public void insertionSort() {
        for (int i = 1; i < size(); i++) {
            for (int j = i; j > 0; j--) {
                if (get(j).compareTo(get(j - 1)) < 0)
                    swap(j, j - 1);
                else
                    break;
            }
        }
    }

    public void quickSort() {
        qSort(0, size() - 1);
    }

    private void qSort(int lower, int upper) {
        if (lower >= upper)
            return;

        // alternativ: new Random().Next(0, Count)
        int pivot = (lower + upper) / 2;

        int divider = divide(lower, upper, pivot);

        qSort(lower, divider - 1);
        qSort(divider + 1, upper);
    }

    private int divide(int lower, int upper, int pivot) {
        T pivotValue = get(pivot);
        int divider = lower;

        swap(pivot, upper);

        for (int i = lower; i < upper; i++) {
            if (get(i).compareTo(pivotValue) < 0) {
                swap(i, divider);
                divider++;
            }
        }
        swap(upper, divider);

        return divider;
    }

    public void mergeSort() {
        mSort(items, size());
    }

    private void mSort(Object[] items, int n) {
        if (n == 1) // Aufteilung bis auf 1 Element
            return;

        int mid = n / 2;
        int leftSize = mid;
        int rightSize = n - leftSize;

        Object[] left = Arrays.copyOfRange(items, 0, leftSize);
        Object[] right = Arrays.copyOfRange(items, mid, n);

        mSort(left, leftSize);
        mSort(right, rightSize);

        merge(items, left, right);
    }

    @SuppressWarnings("unchecked")
    private void merge(Object[] target, Object[] left, Object[] right) {
        int l = 0, r = 0, t = 0;

        int count = left.length + right.length;

        while (count > 0) {
            if (l >= left.length) // der letzte linke wurde bereits verglichen
                target[t] = right[r++];
            else if (r >= right.length) // der letzte rechte wurde bereits verglichen
                target[t] = left[l++];
            else if (((T) left[l]).compareTo((T) right[r]) < 0)
                target[t] = left[l++];
            else
                target[t] = right[r++];

            t++;
            count--;
        }
    }

    public void bucketSort() {
        int max = Integer.parseInt(getMax().toString());
        int min = Integer.parseInt(getMin().toString());
        int n = max - min + 1;

        // Partitionen anlegen
        var partitions = new java.util.ArrayList<SortedArrayList<T>>(n);

        for (int i = 0; i < n; i++)
            partitions.add(new SortedArrayList<T>());

        // Einträge auf Partitionen verteilen
        for (var item : this) {
            int pn = (int) Integer.parseInt(item.toString()) - min;
            partitions.get(pn).add(item);
        }

        // Partitionen konkatenieren
        n = 0;
        for (var pn : partitions) {
            for (var item : pn)
                this.set(n++, item);
        }
    }

    private void swap(int index1, int index2) {
        T item = get(index1);

        set(index1, get(index2));
        set(index2, item);
    }

    public int binarySearch(T item) {
        int lower = 0;
        int upper = size() - 1;

        while (lower <= upper) {
            int mid = (lower + upper) / 2; // alternativ: >> 1 anstatt / 2

            int c = item.compareTo(get(mid));

            if (c == 0)
                return mid;
            else if (c > 0)
                lower = mid + 1; // oben weitersuchen
            else
                upper = mid - 1; // unten weitersuchen
        }

        return ~lower;
    }

    public int binarySearchRecursive(T item) {
        return search(item, 0, size() - 1);
    }

    private int search(T item, int lower, int upper) {

        if (lower > upper)
            return ~lower;

        int mid = (lower + upper) / 2;

        int c = item.compareTo(get(mid));

        if (c == 0)
            return mid;
        else if (c > 0)
            return search(item, mid + 1, upper); // oben weitersuchen
        else
            return search(item, lower, mid - 1); // unten weitersuchen
    }
}
