public final class StringExtension {
    // Umsetzungstabelle für: ABCDEFGHIJKLMNOPQRSTUVWXYZ
    private static String map = "01230120022455012623010202";

    public static String soundex(String text) {
        return soundex(text, 4);
    }

    public static String soundex(String text, int maxLength) {
        if (text == null || text.isEmpty()) {
            return text;
        }

        text = text.toUpperCase();
        StringBuilder code = new StringBuilder(text.length());
        code.append(text.charAt(0));
        char last = '\0';

        for (int i = 1; i < text.length(); i++) {
            char chr = text.charAt(i);

            int letter = chr - 'A';
            if (letter >= 0 && letter < map.length()) {
                if (map.charAt(letter) != last) {
                    code.append(map.charAt(letter));
                    last = map.charAt(letter);
                }
            } else {
                last = '\0';
            }
        }

        code = new StringBuilder(
                code.toString()
                        .replace("0", "")); // Nicht zu berücksichtigende Zeichen entfernen

        if (code.length() > maxLength) {
            code.delete(maxLength, code.length()); // max. Länge
        } else {
            code.append("0".repeat(Math.max(0, maxLength - code.length()))); // auf max. Länge auffüllen
        }

        return code.toString();
    }
}