public final class StringExtension {

    public static double levenshtein(String text1, String text2) {
        int length1 = text1.length();
        int length2 = text2.length();

        int[][] distance = new int[length1 + 1][length2 + 1];

        for (int x = 0; x <= length1; x++)
            distance[x][0] = x;
        for (int y = 0; y <= length2; y++)
            distance[0][y] = y;

        for (int x = 1; x <= length1; x++) {
            for (int y = 1; y <= length2; y++) {
                int cost = text1.charAt(x - 1) == text2.charAt(y - 1) ? 0 : 1;

                distance[x][y] = min(distance[x - 1][y] + 1,
                        distance[x][y - 1] + 1,
                        distance[x - 1][y - 1] + cost);
            }
        }

        return distance[length1][length2];

        // Ähnlichkeitsmaß
        // return 1.0 - ((double)distance[length1][length2] / Math.max( length1,
        // length2));

    }

    private static int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    public static double jaro(String text1, String text2) {
        double length1 = text1.length();
        double length2 = text2.length();

        // zweimal in umgekehrter Reihenfolge, um Transpositionen zu ermitteln
        String common1 = commonChars(text1, text2);
        String common2 = commonChars(text2, text1);

        if (common1.length() == 0 || common1.length() != common2.length())
            return 0;

        double common = common1.length();

        int transpositions = calcTranspositions(common1, common2);

        double similarity = (common / length1 + common / length2 + (common - transpositions) / common) / 3.0;
        return Double.isNaN(similarity) ? 0.0 : similarity;
    }

    private static String commonChars(String text1, String text2) {
        int length1 = text1.length(), length2 = text2.length();

        int halflen = Math.min(length1, length2) / 2; // halbe Länge der kürzeren Zeichenkette

        String common = "";

        for (int x = 0; x < length1; x++) {
            for (int y = Math.max(0, x - halflen); y < Math.min(x + halflen, length2); y++) {
                if (text1.charAt(x) == text2.charAt(y)) {
                    common += text1.charAt(x);
                    break;
                }
            }
        }

        return common;
    }

    private static int calcTranspositions(String common1, String common2) {
        int transpositions = 0;

        for (int pos = 0; pos < Math.min(common1.length(), common2.length()); pos++) {
            if (common1.charAt(pos) != common2.charAt(pos))
                transpositions++;
        }
        return transpositions / 2;
    }
}
